(defun compile-elisp-module (module &optional path every-time)
  (setq module (expand-file-name (symbol-name module) path))
  (let ((el-file (concat module ".el"))
	(elc-file (concat module ".elc")))
    (if (or every-time
	    (file-newer-than-file-p el-file elc-file))
	(byte-compile-file el-file))))

(defun compile-nnimap ()
  (add-to-list 'load-path (expand-file-name "."))
  (compile-elisp-module 'imap4rev1)
  (compile-elisp-module 'nnimap))
